/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fastprojectileapi.entity;

import dev.xkmc.fastprojectileapi.collision.EntityStorageHelper;
import dev.xkmc.fastprojectileapi.collision.ProjectileHitHelper;
import dev.xkmc.fastprojectileapi.entity.ProjectileMovement;
import dev.xkmc.fastprojectileapi.entity.SimplifiedProjectile;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class BaseProjectile
extends SimplifiedProjectile {
    protected BaseProjectile(EntityType<? extends BaseProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8097_() {
    }

    public abstract boolean checkBlockHit();

    public abstract int lifetime();

    @Override
    public void m_8119_() {
        super.m_8119_();
        HitResult hitresult = ProjectileHitHelper.getHitResultOnMoveVector(this, this.checkBlockHit());
        if (hitresult != null) {
            this.onHit(hitresult);
        }
        if (this.f_19797_ >= this.lifetime()) {
            if (this.m_9236_() instanceof ServerLevel) {
                this.projectileMove();
                this.terminate();
                this.markErased(false);
                return;
            }
            Entity owner = this.m_19749_();
            if (this.f_19797_ >= this.lifetime() + 10 || owner == null || !owner.m_6084_()) {
                this.markErased(false);
            }
            return;
        }
        this.projectileMove();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (!this.m_9236_().m_7232_(this.m_20183_().m_123341_() >> 4, this.m_20183_().m_123343_() >> 4) || this.isAddedToWorld() && !EntityStorageHelper.isTicking(sl, this)) {
                this.markErased(false);
            }
        }
    }

    public void m_146871_() {
        if (this.m_20186_() < (double)(this.m_9236_().m_141937_() - 64)) {
            this.markErased(false);
        }
    }

    protected void terminate() {
    }

    protected void projectileMove() {
        ProjectileMovement movement = this.updateVelocity(this.m_20184_(), this.m_20182_());
        this.m_20256_(movement.vec());
        this.updateRotation(movement.rot());
        double d2 = this.m_20185_() + movement.vec().f_82479_;
        double d0 = this.m_20186_() + movement.vec().f_82480_;
        double d1 = this.m_20189_() + movement.vec().f_82481_;
        this.m_6034_(d2, d0, d1);
    }

    protected ProjectileMovement updateVelocity(Vec3 vec, Vec3 pos) {
        return ProjectileMovement.of(vec);
    }

    public boolean m_6783_(double pDistance) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return pDistance < (d0 *= 64.0) * d0;
    }

    protected void onHit(HitResult hitresult) {
        if (hitresult.m_6662_() == HitResult.Type.MISS) {
            return;
        }
        if (hitresult instanceof EntityHitResult) {
            EntityHitResult ehit = (EntityHitResult)hitresult;
            this.onHitEntity(ehit);
            this.m_9236_().m_214171_(GameEvent.f_157777_, hitresult.m_82450_(), GameEvent.Context.m_223719_((Entity)this, null));
        } else if (hitresult instanceof BlockHitResult) {
            BlockHitResult bhit = (BlockHitResult)hitresult;
            BlockPos pos = bhit.m_82425_();
            BlockState state = this.m_9236_().m_8055_(pos);
            if (state.m_60713_(Blocks.f_50142_)) {
                this.m_20221_(pos);
                return;
            }
            if (state.m_60713_(Blocks.f_50446_)) {
                BlockEntity be = this.m_9236_().m_7702_(pos);
                if (be instanceof TheEndGatewayBlockEntity) {
                    TheEndGatewayBlockEntity gate = (TheEndGatewayBlockEntity)be;
                    if (TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                        TheEndGatewayBlockEntity.m_155828_((Level)this.m_9236_(), (BlockPos)pos, (BlockState)state, (Entity)this, (TheEndGatewayBlockEntity)gate);
                    }
                }
                return;
            }
            this.onHitBlock(bhit);
            this.m_9236_().m_220407_(GameEvent.f_157777_, pos, GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(pos)));
        }
    }

    protected void onHitEntity(EntityHitResult pResult) {
    }

    protected void onHitBlock(BlockHitResult pResult) {
    }

    @Override
    public boolean isValid() {
        return this.f_19797_ < this.lifetime();
    }
}

